/*
 Highcharts JS v7.2.0 (2019-09-03)

 Accessibility module

 (c) 2010-2019 Highsoft AS
 Author: Oystein Moseng

 License: www.highcharts.com/license
*/
(function(f){"object"===typeof module&&module.exports?(f["default"]=f,module.exports=f):"function"===typeof define&&define.amd?define("highcharts/modules/accessibility",["highcharts"],function(m){f(m);f.Highcharts=m;return f}):f("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(f){function m(d,f,h,g){d.hasOwnProperty(f)||(d[f]=g.apply(null,h))}f=f?f._modules:{};m(f,"modules/accessibility/KeyboardNavigationHandler.js",[f["parts/Globals.js"]],function(d){function f(d,c){this.chart=d;this.keyCodeMap=
c.keyCodeMap||[];this.validate=c.validate;this.init=c.init;this.terminate=c.terminate;this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}var h=d.find;f.prototype={run:function(d){var c=d.which||d.keyCode,b=this.response.noHandler,a=h(this.keyCodeMap,function(a){return-1<a[0].indexOf(c)});a?b=a[1].call(this,c,d):9===c?b=this.response[d.shiftKey?"prev":"next"]:27===c&&(this.chart&&this.chart.tooltip&&this.chart.tooltip.hide(0),b=this.response.success);return b}};return f});m(f,"modules/accessibility/AccessibilityComponent.js",
[f["parts/Globals.js"]],function(d){function f(){}var h=d.win,g=h.document,c=d.merge,b=d.addEvent;f.prototype={initBase:function(a){this.chart=a;this.eventRemovers=[];this.domElements=[];this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9};this.hiddenStyle={position:"absolute",width:"1px",height:"1px",overflow:"hidden"}},addEvent:function(){var a=d.addEvent.apply(d,arguments);this.eventRemovers.push(a);return a},createElement:function(){var a=d.win.document.createElement.apply(d.win.document,
arguments);this.domElements.push(a);return a},cloneMouseEvent:function(a){if("function"===typeof h.MouseEvent)return new h.MouseEvent(a.type,a);if(g.createEvent){var e=g.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(a.type,"click"===a.type||a.canBubble,a.cancelable,a.view,a.detail,a.screenX,a.screenY,a.clientX,a.clientY,a.ctrlKey,a.altKey,a.shiftKey,a.metaKey,a.button,a.relatedTarget),e;e=g.createEvent("Event");if(e.initEvent)return e.initEvent(a.type,!0,!0),e}},fakeClickEvent:function(a){if(a&&
a.onclick&&g.createEvent){var e=g.createEvent("Event");e.initEvent("click",!0,!1);a.onclick(e)}},createProxyButton:function(a,e,n,l,d){var g=a.element,k=this,p=this.createElement("button"),u=c({"aria-label":g.getAttribute("aria-label")},n);if(a=this.getElementPosition(l||a))return Object.keys(u).forEach(function(a){null!==u[a]&&p.setAttribute(a,u[a])}),c(!0,p.style,{"border-width":0,"background-color":"transparent",position:"absolute",width:(a.width||1)+"px",height:(a.height||1)+"px",display:"block",
cursor:"pointer",overflow:"hidden",outline:"none",opacity:.001,filter:"alpha(opacity=1)","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",zIndex:999,padding:0,margin:0,left:a.x+"px",top:a.y-this.chart.chartHeight+"px"}),d&&b(p,"click",d),["click","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(a){b(p,a,function(e){var b=k.cloneMouseEvent(e);if(g)if(b)g.fireEvent?g.fireEvent(b):g.dispatchEvent&&g.dispatchEvent(b);else if(g["on"+a])g["on"+a](e)})}),e.appendChild(p),
u["aria-hidden"]||this.unhideElementFromScreenReaders(p),p},getElementPosition:function(a){var e=a.element;if((a=this.chart.renderTo)&&e&&e.getBoundingClientRect)return e=e.getBoundingClientRect(),a=a.getBoundingClientRect(),{x:e.left-a.left,y:e.top-a.top,width:e.right-e.left,height:e.bottom-e.top}},addProxyGroup:function(a){var e=this.chart;e.a11yProxyContainer||(e.a11yProxyContainer=g.createElement("div"),e.a11yProxyContainer.style.position="relative");e.container.nextSibling!==e.a11yProxyContainer&&
e.renderTo.insertBefore(e.a11yProxyContainer,e.container.nextSibling);var b=this.createElement("div");Object.keys(a||{}).forEach(function(e){null!==a[e]&&b.setAttribute(e,a[e])});e.a11yProxyContainer.appendChild(b);return b},removeElement:function(a){a&&a.parentNode&&a.parentNode.removeChild(a)},unhideElementFromScreenReaders:function(a){a.setAttribute("aria-hidden",!1);a!==this.chart.renderTo&&a.parentNode&&(Array.prototype.forEach.call(a.parentNode.childNodes,function(a){a.hasAttribute("aria-hidden")||
a.setAttribute("aria-hidden",!0)}),this.unhideElementFromScreenReaders(a.parentNode))},destroyBase:function(){var a=this;this.removeElement((this.chart||{}).a11yProxyContainer);this.eventRemovers.forEach(function(a){a()});this.domElements.forEach(function(e){a.removeElement(e)});this.eventRemovers=[];this.domElements=[]},init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){this.destroyBase()}};return f});m(f,"modules/accessibility/KeyboardNavigation.js",
[f["parts/Globals.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,f){function h(a,b,c){this.init(a,b,c)}var g=d.merge,c=d.addEvent,b=d.win,a=b.document;h.prototype={init:function(e,b){var n=this;this.chart=e;this.components=b;this.modules=[];this.currentModuleIx=0;e.container.hasAttribute("tabIndex")||e.container.setAttribute("tabindex","0");this.addExitAnchor();this.unbindKeydownHandler=c(e.renderTo,"keydown",function(a){n.onKeydown(a)});this.unbindMouseUpHandler=c(a,"mouseup",
function(){n.onMouseUp()});this.update();this.modules.length&&this.modules[0].init(1)},update:function(a){var e=this.chart.options.accessibility;e=e&&e.keyboardNavigation;var b=this.components;e&&e.enabled&&a&&a.length?this.modules=a.reduce(function(a,e){e=b[e].getKeyboardNavigation();return e.length?a.concat(e):(a.push(e),a)},[new f(this.chart,{})]):(this.modules=[],this.currentModuleIx=0)},onMouseUp:function(){if(!(this.keyboardReset||this.chart.pointer&&this.chart.pointer.chartPosition)){var a=
this.chart,b=this.modules&&this.modules[this.currentModuleIx||0];b&&b.terminate&&b.terminate();a.focusElement&&a.focusElement.removeFocusBorder();this.currentModuleIx=0;this.keyboardReset=!0}},onKeydown:function(a){a=a||b.event;var e,c=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];this.keyboardReset=!1;if(c){var d=c.run(a);d===c.response.success?e=!0:d===c.response.prev?e=this.prev():d===c.response.next&&(e=this.next());e&&a.preventDefault()}},prev:function(){return this.move(-1)},
next:function(){return this.move(1)},move:function(a){var b=this.modules&&this.modules[this.currentModuleIx];b&&b.terminate&&b.terminate(a);this.chart.focusElement&&this.chart.focusElement.removeFocusBorder();this.currentModuleIx+=a;if(b=this.modules&&this.modules[this.currentModuleIx]){if(b.validate&&!b.validate())return this.move(a);if(b.init)return b.init(a),!0}this.currentModuleIx=0;0<a?(this.exiting=!0,this.exitAnchor.focus()):this.chart.renderTo.focus();return!1},addExitAnchor:function(){var e=
this.chart,d=this.exitAnchorWrapper=a.createElement("div"),l=this.exitAnchor=a.createElement("h6"),f=this,h=e.langFormat("accessibility.svgContainerEnd",{chart:e});l.innerHTML=h;d.setAttribute("aria-hidden","false");d.setAttribute("class","highcharts-exit-anchor-wrapper");d.style.position="relative";d.style.outline="none";l.setAttribute("tabindex","0");l.setAttribute("aria-hidden",!1);g(!0,l.style,{position:"absolute",width:"1px",height:"1px",bottom:"5px",zIndex:0,overflow:"hidden",outline:"none"});
d.appendChild(l);e.renderTo.appendChild(d);this.unbindExitAnchorUpdate=c(e,"render",function(){this.renderTo.appendChild(d)});this.unbindExitAnchorFocus=c(l,"focus",function(a){a=a||b.event;f.exiting?f.exiting=!1:(e.renderTo.focus(),a.preventDefault(),f.modules&&f.modules.length&&(f.currentModuleIx=f.modules.length-1,(a=f.modules[f.currentModuleIx])&&a.validate&&!a.validate()?f.prev():a&&a.init(-1)))})},destroy:function(){this.unbindExitAnchorFocus&&(this.unbindExitAnchorFocus(),delete this.unbindExitAnchorFocus);
this.unbindExitAnchorUpdate&&(this.unbindExitAnchorUpdate(),delete this.unbindExitAnchorUpdate);this.exitAnchorWrapper&&this.exitAnchorWrapper.parentNode&&(this.exitAnchorWrapper.parentNode.removeChild(this.exitAnchorWrapper),delete this.exitAnchor,delete this.exitAnchorWrapper);this.unbindKeydownHandler&&this.unbindKeydownHandler();this.unbindMouseUpHandler&&this.unbindMouseUpHandler()}};return h});m(f,"modules/accessibility/utilities.js",[],function(){function d(d){return d.replace(/&/g,"&amp;").replace(/</g,
"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}return{stripHTMLTagsFromString:function(d){return"string"===typeof d?d.replace(/<\/?[^>]+(>|$)/g,""):d},makeHTMLTagFromText:function(f,h){return"<"+f+">"+d(h)+"</"+f+">"},escapeStringForHTML:d}});m(f,"modules/accessibility/components/LegendComponent.js",[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"],f["modules/accessibility/utilities.js"]],
function(d,f,h,g){var c=g.stripHTMLTagsFromString;d.Chart.prototype.highlightLegendItem=function(b){var a=this.legend.allItems,e=this.highlightedLegendItemIx;return a[b]?(a[e]&&d.fireEvent(a[e].legendGroup.element,"mouseout"),void 0!==a[b].pageIx&&a[b].pageIx+1!==this.legend.currentPage&&this.legend.scroll(1+a[b].pageIx-this.legend.currentPage),this.setFocusToElement(a[b].legendItem,a[b].a11yProxyElement),d.fireEvent(a[b].legendGroup.element,"mouseover"),!0):!1};d.addEvent(d.Legend,"afterColorizeItem",
function(b){var a=b.item;this.chart.options.accessibility.enabled&&a&&a.a11yProxyElement&&a.a11yProxyElement.setAttribute("aria-pressed",b.visible?"false":"true")});g=function(b){this.initBase(b)};g.prototype=new f;d.extend(g.prototype,{onChartRender:function(){var b=this.chart,a=b.options.accessibility,e=b.legend&&b.legend.allItems,d=this;d.legendProxyButtonClicked?delete d.legendProxyButtonClicked:(this.removeElement(this.legendProxyGroup),!e||!e.length||b.colorAxis&&b.colorAxis.length||!b.options.legend.accessibility.enabled||
(this.legendProxyGroup=this.addProxyGroup({"aria-label":b.langFormat("accessibility.legendLabel"),role:"all"===a.landmarkVerbosity?"region":null}),e.forEach(function(a){a.legendItem&&a.legendItem.element&&(a.a11yProxyElement=d.createProxyButton(a.legendItem,d.legendProxyGroup,{tabindex:-1,"aria-pressed":!a.visible,"aria-label":b.langFormat("accessibility.legendItem",{chart:b,itemName:c(a.name)})},a.legendGroup.div?a.legendItem:a.legendGroup,function(){d.legendProxyButtonClicked=!0}))})))},getKeyboardNavigation:function(){var b=
this.keyCodes,a=this,e=this.chart,c=e.options.accessibility;return new h(e,{keyCodeMap:[[[b.left,b.right,b.up,b.down],function(d){d=d===b.left||d===b.up?-1:1;return e.highlightLegendItem(a.highlightedLegendItemIx+d)?(a.highlightedLegendItemIx+=d,this.response.success):1<e.legend.allItems.length&&c.keyboardNavigation.wrapAround?(this.init(d),this.response.success):this.response[0<d?"next":"prev"]}],[[b.enter,b.space],function(){var b=e.legend.allItems[a.highlightedLegendItemIx];b&&b.a11yProxyElement&&
d.fireEvent(b.a11yProxyElement,"click");return this.response.success}]],validate:function(){var a=e.options.legend;return e.legend&&e.legend.allItems&&e.legend.display&&!(e.colorAxis&&e.colorAxis.length)&&a&&a.accessibility&&a.accessibility.enabled&&a.accessibility.keyboardNavigation&&a.accessibility.keyboardNavigation.enabled},init:function(b){b=0<b?0:e.legend.allItems.length-1;e.highlightLegendItem(b);a.highlightedLegendItemIx=b}})}});return g});m(f,"modules/accessibility/components/MenuComponent.js",
[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,f,h){d.Chart.prototype.showExportMenu=function(){this.exportSVGElements&&this.exportSVGElements[0]&&(this.exportSVGElements[0].element.onclick(),this.highlightExportItem(0))};d.Chart.prototype.hideExportMenu=function(){var c=this.exportDivElements;c&&this.exportContextMenu&&(c.forEach(function(b){if("highcharts-menu-item"===b.className&&b.onmouseout)b.onmouseout()}),
this.highlightedExportItemIx=0,this.exportContextMenu.hideMenu(),this.container.focus())};d.Chart.prototype.highlightExportItem=function(c){var b=this.exportDivElements&&this.exportDivElements[c],a=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx];if(b&&"DIV"===b.tagName&&(!b.children||!b.children.length)){var e=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus;b.focus&&e&&b.focus();if(a&&a.onmouseout)a.onmouseout();if(b.onmouseover)b.onmouseover();this.highlightedExportItemIx=
c;return!0}};d.Chart.prototype.highlightLastExportItem=function(){var c;if(this.exportDivElements)for(c=this.exportDivElements.length;c--;)if(this.highlightExportItem(c))return!0;return!1};var g=function(c){this.initBase(c);this.init()};g.prototype=new f;d.extend(g.prototype,{init:function(){this.addEvent(this.chart,"exportMenuHidden",function(){var c=this.exportContextMenu;c&&c.setAttribute("aria-hidden",!0)})},onChartRender:function(){var c=this,b=this.chart,a=b.options.accessibility;this.removeElement(this.exportProxyGroup);
if(b.options.exporting&&!1!==b.options.exporting.enabled&&b.options.exporting.accessibility&&b.options.exporting.accessibility.enabled&&b.exportSVGElements&&b.exportSVGElements[0]&&b.exportSVGElements[0].element){var e=b.exportSVGElements[0],d=e.element,f=d.onclick;this.wrappedButton!==d&&(d.onclick=function(){f.apply(this,Array.prototype.slice.call(arguments));c.addAccessibleContextMenuAttribs();b.highlightExportItem(0)},this.wrappedButton=d);this.exportProxyGroup=this.addProxyGroup("all"===a.landmarkVerbosity?
{"aria-label":b.langFormat("accessibility.exporting.exportRegionLabel",{chart:b}),role:"region"}:null);this.exportButtonProxy=this.createProxyButton(e,this.exportProxyGroup,{"aria-label":b.langFormat("accessibility.exporting.menuButtonLabel",{chart:b})})}},addAccessibleContextMenuAttribs:function(){var c=this.chart,b=c.exportDivElements,a=c.exportContextMenu;b&&b.length&&(b.forEach(function(a){"DIV"!==a.tagName||a.children&&a.children.length||(a.setAttribute("role","menuitem"),a.setAttribute("tabindex",
-1))}),b[0].parentNode.setAttribute("role","menu"),b[0].parentNode.setAttribute("aria-label",c.langFormat("accessibility.exporting.chartMenuLabel",{chart:c})));a&&this.unhideElementFromScreenReaders(a)},getKeyboardNavigation:function(){var c=this.keyCodes,b=this.chart,a=b.options.accessibility,e=this;return new h(b,{keyCodeMap:[[[c.left,c.up],function(){for(var e=b.highlightedExportItemIx||0;e--;)if(b.highlightExportItem(e))return this.response.success;return a.keyboardNavigation.wrapAround?(b.highlightLastExportItem(),
this.response.success):this.response.prev}],[[c.right,c.down],function(){for(var e=(b.highlightedExportItemIx||0)+1;e<b.exportDivElements.length;++e)if(b.highlightExportItem(e))return this.response.success;return a.keyboardNavigation.wrapAround?(b.highlightExportItem(0),this.response.success):this.response.next}],[[c.enter,c.space],function(){e.fakeClickEvent(b.exportDivElements[b.highlightedExportItemIx]);return this.response.success}],[[c.esc],function(){return this.response.prev}]],validate:function(){return b.exportChart&&
!1!==b.options.exporting.enabled&&!1!==b.options.exporting.accessibility.enabled},init:function(a){b.showExportMenu();0>a&&b.highlightLastExportItem()},terminate:function(){b.hideExportMenu()}})}});return g});m(f,"modules/accessibility/components/SeriesComponent.js",[f["parts/Globals.js"],f["parts/Utilities.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"],f["modules/accessibility/utilities.js"]],function(d,f,h,g,c){function b(a){var b=
a.index,e=a.series.points,k=e.length;if(e[b]!==a)for(;k--;){if(e[k]===a)return k}else return b}function a(a){var b=a.chart.options.accessibility,e=a.options.accessibility||{},k=e.keyboardNavigation;return k&&!1===k.enabled||!1===e.enabled||!1===a.options.enableMouseTracking||!a.visible||b.pointNavigationThreshold&&b.pointNavigationThreshold<=a.points.length}function e(b){var e=b.series.chart.options.accessibility;return b.isNull&&e.keyboardNavigation.skipNullPoints||!1===b.visible||a(b.series)}var n=
f.isNumber,l=d.merge,t=d.pick,r=c.stripHTMLTagsFromString;d.Series.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(a){d.seriesTypes[a]&&(d.seriesTypes[a].prototype.keyboardMoveVertical=!1)});d.addEvent(d.Series,"render",function(){var a=this.options,b=this.chart.options.accessibility||{},e=this.points||[],c=e.length,d=this.resetA11yMarkerOptions;if(b.enabled&&!1!==(a.accessibility&&a.accessibility.enabled)&&(c<b.pointDescriptionThreshold||!1===b.pointDescriptionThreshold||c<b.pointNavigationThreshold||
!1===b.pointNavigationThreshold)){if(a.marker&&!1===a.marker.enabled&&(this.a11yMarkersForced=!0,l(!0,this.options,{marker:{enabled:!0,states:{normal:{opacity:0}}}})),this._hasPointMarkers&&this.points&&this.points.length)for(a=c;a--;)b=e[a].options,b.marker&&(b.marker.enabled?l(!0,b.marker,{states:{normal:{opacity:b.marker.states&&b.marker.states.normal&&b.marker.states.normal.opacity||1}}}):l(!0,b.marker,{enabled:!0,states:{normal:{opacity:0}}}))}else this.a11yMarkersForced&&d&&(delete this.a11yMarkersForced,
l(!0,this.options,{marker:{enabled:d.enabled,states:{normal:{opacity:d.states&&d.states.normal&&d.states.normal.opacity}}}}))});d.addEvent(d.Series,"afterSetOptions",function(a){this.resetA11yMarkerOptions=l(a.options.marker||{},this.userOptions.marker||{})});d.Point.prototype.highlight=function(){var a=this.series.chart;if(this.isNull)a.tooltip&&a.tooltip.hide(0);else this.onMouseOver();this.graphic&&a.setFocusToElement(this.graphic);a.highlightedPoint=this;return this};d.Chart.prototype.highlightAdjacentPoint=
function(c){var k=this.series,d=this.highlightedPoint,f=d&&b(d)||0,g=d&&d.series.points,n=this.series&&this.series[this.series.length-1];n=n&&n.points&&n.points[n.points.length-1];if(!k[0]||!k[0].points)return!1;if(d){if(k=k[d.series.index+(c?1:-1)],f=g[f+(c?1:-1)],!f&&k&&(f=k.points[c?0:k.points.length-1]),!f)return!1}else f=c?k[0].points[0]:n;return e(f)?(k=f.series,a(k)?this.highlightedPoint=c?k.points[k.points.length-1]:k.points[0]:this.highlightedPoint=f,this.highlightAdjacentPoint(c)):f.highlight()};
d.Series.prototype.highlightFirstValidPoint=function(){var a=this.chart.highlightedPoint,c=(a&&a.series)===this?b(a):0;a=this.points;var d=a.length;if(a&&d){for(var f=c;f<d;++f)if(!e(a[f]))return a[f].highlight();for(;0<=c;--c)if(!e(a[c]))return a[c].highlight()}return!1};d.Chart.prototype.highlightAdjacentSeries=function(b){var e,c,k=this.highlightedPoint,d=(e=this.series&&this.series[this.series.length-1])&&e.points&&e.points[e.points.length-1];if(!this.highlightedPoint)return e=b?this.series&&
this.series[0]:e,(c=b?e&&e.points&&e.points[0]:d)?c.highlight():!1;e=this.series[k.series.index+(b?-1:1)];if(!e)return!1;d=Infinity;var f=e.points.length;if(void 0===k.plotX||void 0===k.plotY)c=void 0;else{for(;f--;){var g=e.points[f];void 0!==g.plotX&&void 0!==g.plotY&&(g=(k.plotX-g.plotX)*(k.plotX-g.plotX)*4+(k.plotY-g.plotY)*(k.plotY-g.plotY),g<d&&(d=g,c=f))}c=void 0!==c&&e.points[c]}if(!c)return!1;if(a(e))return c.highlight(),b=this.highlightAdjacentSeries(b),b?b:(k.highlight(),!1);c.highlight();
return c.series.highlightFirstValidPoint()};d.Chart.prototype.highlightAdjacentPointVertical=function(b){var c=this.highlightedPoint,k=Infinity,d;if(void 0===c.plotX||void 0===c.plotY)return!1;this.series.forEach(function(f){a(f)||f.points.forEach(function(a){if(void 0!==a.plotY&&void 0!==a.plotX&&a!==c){var p=a.plotY-c.plotY,g=Math.abs(a.plotX-c.plotX);g=Math.abs(p)*Math.abs(p)+g*g*4;f.yAxis.reversed&&(p*=-1);!(0>=p&&b||0<=p&&!b||5>g||e(a))&&g<k&&(k=g,d=a)}})});return d?d.highlight():!1};d.Point.prototype.getA11yTimeDescription=
function(){var a=this.series,b=a.chart,e=b.options.accessibility;if(a.xAxis&&a.xAxis.isDatetimeAxis)return b.time.dateFormat(e.pointDateFormatter&&e.pointDateFormatter(this)||e.pointDateFormat||d.Tooltip.prototype.getXDateFormat.call({getDateFormat:d.Tooltip.prototype.getDateFormat,chart:b},this,b.options.tooltip,a.xAxis),this.x)};f=function(a){this.initBase(a);this.init()};f.prototype=new h;d.extend(f.prototype,{init:function(){var a=this;this.addEvent(d.Series,"destroy",function(){var b=this.chart;
b===a.chart&&b.highlightedPoint&&b.highlightedPoint.series===this&&(delete b.highlightedPoint,b.focusElement&&b.focusElement.removeFocusBorder())});this.addEvent(d.Tooltip,"refresh",function(){this.chart===a.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)});this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(a){a.labelBySeries&&a.labelBySeries.attr("aria-hidden",!0)})});this.initAnnouncer()},onChartRender:function(){var a=
this;this.chart.series.forEach(function(b){a[!1!==(b.options.accessibility&&b.options.accessibility.enabled)&&b.visible?"addSeriesDescription":"hideSeriesFromScreenReader"](b)})},getKeyboardNavigation:function(){var a=this.keyCodes,b=this.chart,e=b.inverted,c=b.options.accessibility,d=function(a){return b.highlightAdjacentPoint(a)?this.response.success:c.keyboardNavigation.wrapAround?this.init(a?1:-1):this.response[a?"next":"prev"]};return new g(b,{keyCodeMap:[[[e?a.up:a.left,e?a.down:a.right],function(b){return d.call(this,
b===a.right||b===a.down)}],[[e?a.left:a.up,e?a.right:a.down],function(e){e=e===a.down||e===a.right;var k=c.keyboardNavigation;if(k.mode&&"serialize"===k.mode)return d.call(this,e);b[b.highlightedPoint&&b.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries"](e);return this.response.success}],[[a.enter,a.space],function(){b.highlightedPoint&&b.highlightedPoint.firePointEvent("click")}]],init:function(a){var e=b.series.length,c=0<a?0:e;if(0<a)for(delete b.highlightedPoint;c<
e&&!(a=b.series[c].highlightFirstValidPoint());)++c;else for(;c--&&!(b.highlightedPoint=b.series[c].points[b.series[c].points.length-1],a=b.series[c].highlightFirstValidPoint()););return this.response.success},terminate:function(){b.tooltip&&b.tooltip.hide(0);delete b.highlightedPoint}})},isPointClickable:function(a){var b=a.series.options||{};b=b.point&&b.point.events;return a&&a.graphic&&a.graphic.element&&(a.hcEvents&&a.hcEvents.click||b&&b.click||a.options&&a.options.events&&a.options.events.click)},
initAnnouncer:function(){var a=this.chart,b=a.options.accessibility,e=this;this.lastAnnouncementTime=0;this.dirty={allSeries:{}};this.announceRegion=this.createElement("div");this.announceRegion.setAttribute("aria-hidden",!1);this.announceRegion.setAttribute("aria-live",b.announceNewData.interruptUser?"assertive":"polite");l(!0,this.announceRegion.style,this.hiddenStyle);a.renderTo.insertBefore(this.announceRegion,a.renderTo.firstChild);this.addEvent(this.chart,"afterDrilldown",function(){a.highlightedPoint=
null;if(a.options.accessibility.announceNewData.enabled){if(this.series&&this.series.length){var b=e.getSeriesElement(this.series[0]);b.focus&&b.getAttribute("aria-label")?b.focus():this.series[0].highlightFirstValidPoint()}e.lastAnnouncementTime=0;a.focusElement&&a.focusElement.removeFocusBorder()}});this.addEvent(d.Series,"updatedData",function(){this.chart===a&&this.chart.options.accessibility.announceNewData.enabled&&(e.dirty.hasDirty=!0,e.dirty.allSeries[this.name+this.index]=this)});this.addEvent(a,
"afterAddSeries",function(a){this.options.accessibility.announceNewData.enabled&&(a=a.series,e.dirty.hasDirty=!0,e.dirty.allSeries[a.name+a.index]=a,e.dirty.newSeries=void 0===e.dirty.newSeries?a:null)});this.addEvent(d.Series,"addPoint",function(b){this.chart===a&&this.chart.options.accessibility.announceNewData.enabled&&(e.dirty.newPoint=void 0===e.dirty.newPoint?b.point:null)});this.addEvent(a,"redraw",function(){if(this.options.accessibility.announceNewData&&e.dirty.hasDirty){var a=e.dirty.newPoint;
if(a){var b=a.series.data.filter(function(b){return b.x===a.x&&b.y===a.y});a=1===b.length?b[0]:a}e.announceNewData(Object.keys(e.dirty.allSeries).map(function(a){return e.dirty.allSeries[a]}),e.dirty.newSeries,a);e.dirty={allSeries:{}}}})},announceNewData:function(a,b,e){var c=this.chart.options.accessibility.announceNewData;if(c.enabled){var d=this,f=+new Date;c=Math.max(0,c.minAnnounceInterval-(f-this.lastAnnouncementTime));if(this.queuedAnnouncement){var k=(this.queuedAnnouncement.series||[]).concat(a).reduce(function(a,
b){a[b.name+b.index]=b;return a},{});a=Object.keys(k).map(function(a){return k[a]})}else a=[].concat(a);if(b=this.buildAnnouncementMessage(a,b,e))this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:f,message:b,series:a},d.queuedAnnouncementTimer=setTimeout(function(){d&&d.announceRegion&&(d.lastAnnouncementTime=+new Date,d.announceRegion.innerHTML=d.queuedAnnouncement.message,d.clearAnnouncementContainerTimer&&clearTimeout(d.clearAnnouncementContainerTimer),
d.clearAnnouncementContainerTimer=setTimeout(function(){d.announceRegion.innerHTML="";delete d.clearAnnouncementContainerTimer},1E3),delete d.queuedAnnouncement,delete d.queuedAnnouncementTimer)},c)}},buildAnnouncementMessage:function(a,b,e){var c=this.chart,f=c.options.accessibility.announceNewData;if(f.announcementFormatter&&(a=f.announcementFormatter(a,b,e),!1!==a))return a.length?a:null;a=d.charts&&1<d.charts.length?"Multiple":"Single";return c.langFormat("accessibility.announceNewData."+(b?"newSeriesAnnounce"+
a:e?"newPointAnnounce"+a:"newDataAnnounce"),{chartTitle:r(c.options.title.text||c.langFormat("accessibility.defaultChartTitle",{chart:c})),seriesDesc:b?this.defaultSeriesDescriptionFormatter(b):null,pointDesc:e?this.defaultPointDescriptionFormatter(e):null,point:e,series:b})},reverseChildNodes:function(a){for(var b=a.childNodes.length;b--;)a.appendChild(a.childNodes[b])},getSeriesFirstPointElement:function(a){return a.points&&a.points.length&&a.points[0].graphic&&a.points[0].graphic.element},getSeriesElement:function(a){var b=
this.getSeriesFirstPointElement(a);return b&&b.parentNode||a.graph&&a.graph.element||a.group&&a.group.element},hideSeriesFromScreenReader:function(a){(a=this.getSeriesElement(a))&&a.setAttribute("aria-hidden",!0)},addSeriesDescription:function(a){var b=this,e=a.chart,c=e.options.accessibility,d=a.options.accessibility||{},f=b.getSeriesFirstPointElement(a),g=b.getSeriesElement(a),k=a.points&&(a.points.length<c.pointDescriptionThreshold||!1===c.pointDescriptionThreshold)&&!d.exposeAsGroupOnly,n=a.points&&
(a.points.length<c.pointNavigationThreshold||!1===c.pointNavigationThreshold);g&&(g.lastChild===f&&b.reverseChildNodes(g),b.unhideElementFromScreenReaders(g),(k||n)&&a.points.forEach(function(a){var e=a.graphic&&a.graphic.element;e&&(e.setAttribute("tabindex","-1"),k?(e.setAttribute("role","img"),e.setAttribute("aria-label",r(d.pointDescriptionFormatter&&d.pointDescriptionFormatter(a)||c.pointDescriptionFormatter&&c.pointDescriptionFormatter(a)||b.defaultPointDescriptionFormatter(a)))):e.setAttribute("aria-hidden",
!0))}),1<e.series.length||c.describeSingleSeries?(d.exposeAsGroupOnly?g.setAttribute("role","img"):"all"===c.landmarkVerbosity&&g.setAttribute("role","region"),g.setAttribute("tabindex","-1"),g.setAttribute("aria-label",r(c.seriesDescriptionFormatter&&c.seriesDescriptionFormatter(a)||b.defaultSeriesDescriptionFormatter(a)))):g.setAttribute("aria-label",""))},defaultSeriesDescriptionFormatter:function(a){var b=a.chart,e=(a.options.accessibility||{}).description;e=e&&b.langFormat("accessibility.series.description",
{description:e,series:a});var c=b.langFormat("accessibility.series.xAxisDescription",{name:a.xAxis&&a.xAxis.getDescription(),series:a}),d=b.langFormat("accessibility.series.yAxisDescription",{name:a.yAxis&&a.yAxis.getDescription(),series:a}),f={name:a.name||"",ix:a.index+1,numSeries:b.series&&b.series.length,numPoints:a.points&&a.points.length,series:a},g=b.types&&1<b.types.length?"Combination":"";return(b.langFormat("accessibility.series.summary."+a.type+g,f)||b.langFormat("accessibility.series.summary.default"+
g,f))+(e?" "+e:"")+(b.yAxis&&1<b.yAxis.length&&this.yAxis?" "+d:"")+(b.xAxis&&1<b.xAxis.length&&this.xAxis?" "+c:"")},defaultPointDescriptionFormatter:function(a){var b=a.series,e=b.chart,c=e.options.accessibility,f=a.series.tooltipOptions||{},g=c.pointValuePrefix||f.valuePrefix||"",l=c.pointValueSuffix||f.valueSuffix||"",k=a.options&&a.options.accessibility&&a.options.accessibility.description,h=a.getA11yTimeDescription(),w=function(a){if(n(a)){var b=d.defaultOptions.lang;return d.numberFormat(a,
c.pointValueDecimals||f.valueDecimals||-1,b.decimalPoint,b.accessibility.thousandsSep||b.thousandsSep)}return a},C=t(b.xAxis&&b.xAxis.options.accessibility&&b.xAxis.options.accessibility.enabled,!e.angular),v=b.xAxis&&b.xAxis.categories&&void 0!==a.category&&""+a.category;h=a.name||h||v&&v.replace("<br/>"," ")||(a.id&&0>a.id.indexOf("highcharts-")?a.id:"x, "+a.x);v=a.series.pointArrayMap?a.series.pointArrayMap.reduce(function(b,e){return b+(b.length?", ":"")+e+": "+g+w(t(a[e],a.options[e]))+l},""):
void 0!==a.value?g+w(a.value)+l:g+w(a.y)+l;return(void 0!==a.index?a.index+1+". ":"")+(C?h+", ":"")+v+"."+(k?" "+k:"")+(1<e.series.length&&b.name?" "+b.name:"")}});return f});m(f,"modules/accessibility/components/ZoomComponent.js",[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,f,h){d.Axis.prototype.panStep=function(c,b){var a=b||3;b=this.getExtremes();var e=(b.max-b.min)/a*c;a=b.max+e;e=b.min+e;var d=
a-e;0>c&&e<b.dataMin?(e=b.dataMin,a=e+d):0<c&&a>b.dataMax&&(a=b.dataMax,e=a-d);this.setExtremes(e,a)};var g=function(c){this.initBase(c);this.init()};g.prototype=new f;d.extend(g.prototype,{init:function(){var c=this,b=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(a){c.addEvent(b,a,function(){c.updateProxyOverlays()})})},onChartUpdate:function(){var c=this.chart,b=this;c.mapNavButtons&&c.mapNavButtons.forEach(function(a,e){b.unhideElementFromScreenReaders(a.element);
a.element.setAttribute("tabindex",-1);a.element.setAttribute("role","button");a.element.setAttribute("aria-label",c.langFormat("accessibility.mapZoom"+(e?"Out":"In"),{chart:c}))})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var c=this,b=this.chart,a=function(a,b,d,f){c.removeElement(c[d]);c[d]=c.addProxyGroup();c[b]=c.createProxyButton(a,c[d],{"aria-label":f,tabindex:-1})};c.removeElement(c.drillUpProxyGroup);c.removeElement(c.resetZoomProxyGroup);b.resetZoomButton&&
a(b.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",b.langFormat("accessibility.resetZoomButton",{chart:b}));b.drillUpButton&&a(b.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",b.langFormat("accessibility.drillUpButton",{chart:b,buttonText:b.getDrilldownBackText()}))},getMapZoomNavigation:function(){var c=this.keyCodes,b=this.chart,a=this;return new h(b,{keyCodeMap:[[[c.up,c.down,c.left,c.right],function(a){b[a===c.up||a===c.down?"yAxis":"xAxis"][0].panStep(a===c.left||a===c.up?
-1:1);return this.response.success}],[[c.tab],function(e,c){b.mapNavButtons[a.focusedMapNavButtonIx].setState(0);if(c.shiftKey&&!a.focusedMapNavButtonIx||!c.shiftKey&&a.focusedMapNavButtonIx)return b.mapZoom(),this.response[c.shiftKey?"prev":"next"];a.focusedMapNavButtonIx+=c.shiftKey?-1:1;e=b.mapNavButtons[a.focusedMapNavButtonIx];b.setFocusToElement(e.box,e.element);e.setState(2);return this.response.success}],[[c.space,c.enter],function(){a.fakeClickEvent(b.mapNavButtons[a.focusedMapNavButtonIx].element);
return this.response.success}]],validate:function(){return b.mapZoom&&b.mapNavButtons&&2===b.mapNavButtons.length},init:function(e){var c=b.mapNavButtons[0],d=b.mapNavButtons[1];c=0<e?c:d;b.setFocusToElement(c.box,c.element);c.setState(2);a.focusedMapNavButtonIx=0<e?0:1}})},simpleButtonNavigation:function(c,b,a){var e=this.keyCodes,d=this,f=this.chart;return new h(f,{keyCodeMap:[[[e.tab,e.up,e.down,e.left,e.right],function(a,b){return this.response[a===this.tab&&b.shiftKey||a===e.left||a===e.up?"prev":
"next"]}],[[e.space,e.enter],function(){a(f);return this.response.success}]],validate:function(){return f[c]&&f[c].box&&d[b]},init:function(){f.setFocusToElement(f[c].box,d[b])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(c){c.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(c){c.drillUp()}),this.getMapZoomNavigation()]}});return g});m(f,"modules/accessibility/components/RangeSelectorComponent.js",
[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(d,f,h){d.Chart.prototype.highlightRangeSelectorButton=function(c){var b=this.rangeSelector.buttons;b[this.highlightedRangeSelectorItemIx]&&b[this.highlightedRangeSelectorItemIx].setState(this.oldRangeSelectorItemState||0);this.highlightedRangeSelectorItemIx=c;return b[c]?(this.setFocusToElement(b[c].box,b[c].element),this.oldRangeSelectorItemState=b[c].state,
b[c].setState(2),!0):!1};var g=function(c){this.initBase(c)};g.prototype=new f;d.extend(g.prototype,{onChartUpdate:function(){var c=this.chart,b=this,a=c.rangeSelector;a&&(a.buttons&&a.buttons.length&&a.buttons.forEach(function(a){b.unhideElementFromScreenReaders(a.element);a.element.setAttribute("tabindex","-1");a.element.setAttribute("role","button");a.element.setAttribute("aria-label",c.langFormat("accessibility.rangeSelectorButton",{chart:c,buttonText:a.text&&a.text.textStr}))}),a.maxInput&&a.minInput&&
["minInput","maxInput"].forEach(function(e,d){a[e]&&(b.unhideElementFromScreenReaders(a[e]),a[e].setAttribute("tabindex","-1"),a[e].setAttribute("role","textbox"),a[e].setAttribute("aria-label",c.langFormat("accessibility.rangeSelector"+(d?"MaxInput":"MinInput"),{chart:c})))}))},getRangeSelectorButtonNavigation:function(){var c=this.chart,b=this.keyCodes,a=c.options.accessibility,e=this;return new h(c,{keyCodeMap:[[[b.left,b.right,b.up,b.down],function(e){e=e===b.left||e===b.up?-1:1;if(!c.highlightRangeSelectorButton(c.highlightedRangeSelectorItemIx+
e))return a.keyboardNavigation.wrapAround?(this.init(e),this.response.success):this.response[0<e?"next":"prev"]}],[[b.enter,b.space],function(){3!==c.oldRangeSelectorItemState&&e.fakeClickEvent(c.rangeSelector.buttons[c.highlightedRangeSelectorItemIx].element)}]],validate:function(){return c.rangeSelector&&c.rangeSelector.buttons&&c.rangeSelector.buttons.length},init:function(a){c.highlightRangeSelectorButton(0<a?0:c.rangeSelector.buttons.length-1)}})},getRangeSelectorInputNavigation:function(){var c=
this.chart,b=this.keyCodes;return new h(c,{keyCodeMap:[[[b.tab,b.up,b.down],function(a,e){a=a===b.tab&&e.shiftKey||a===b.up?-1:1;e=c.highlightedInputRangeIx+=a;if(1<e||0>e)return this.response[0<a?"next":"prev"];c.rangeSelector[e?"maxInput":"minInput"].focus();return this.response.success}]],validate:function(){return c.rangeSelector&&c.rangeSelector.inputGroup&&"hidden"!==c.rangeSelector.inputGroup.element.getAttribute("visibility")&&!1!==c.options.rangeSelector.inputEnabled&&c.rangeSelector.minInput&&
c.rangeSelector.maxInput},init:function(a){c.highlightedInputRangeIx=0<a?0:1;c.rangeSelector[c.highlightedInputRangeIx?"maxInput":"minInput"].focus()},terminate:function(){var a=c.rangeSelector;a&&a.maxInput&&a.minInput&&(a.hideInput("max"),a.hideInput("min"))}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]}});return g});m(f,"modules/accessibility/components/InfoRegionComponent.js",[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],
f["modules/accessibility/utilities.js"]],function(d,f,h){var g=d.merge,c=d.pick,b=h.makeHTMLTagFromText;d.Chart.prototype.getTypeDescription=function(a){a=a[0];var b=this.series&&this.series[0]||{},c=b.mapTitle;b={numSeries:this.series.length,numPoints:b.points&&b.points.length,chart:this,mapTitle:c};if(!a)return this.langFormat("accessibility.chartTypes.emptyChart",b);if("map"===a)return c?this.langFormat("accessibility.chartTypes.mapTypeDescription",b):this.langFormat("accessibility.chartTypes.unknownMap",
b);if(1<this.types.length)return this.langFormat("accessibility.chartTypes.combinationChart",b);c=this.langFormat("accessibility.seriesTypeDescriptions."+a,{chart:this});var d=this.series&&1===this.series.length?"Single":"Multiple";return(this.langFormat("accessibility.chartTypes."+a+d,b)||this.langFormat("accessibility.chartTypes.default"+d,b))+(c?" "+c:"")};h=function(a){this.initBase(a);this.init()};h.prototype=new f;d.extend(h.prototype,{init:function(){var a=this.chart,b=this;this.addEvent(a,
"afterGetTable",function(e){a.options.accessibility.enabled&&(b.tableAnchor.setAttribute("aria-expanded",!0),e.html=e.html.replace("<table ",'<table tabindex="0" summary="'+a.langFormat("accessibility.tableSummary",{chart:a})+'"'))});this.addEvent(a,"afterViewData",function(a){setTimeout(function(){var b=a&&a.getElementsByTagName("table")[0];b&&b.focus&&b.focus()},300)})},onChartUpdate:function(){var a=this.chart,b=a.options.accessibility,c="highcharts-information-region-"+a.index,d=this.screenReaderRegion=
this.screenReaderRegion||this.createElement("div"),f=this.tableHeading=this.tableHeading||this.createElement("h6"),h=this.tableAnchor=this.tableAnchor||this.createElement("a"),k=this.chartHeading=this.chartHeading||this.createElement("h6");d.setAttribute("id",c);"all"===b.landmarkVerbosity&&d.setAttribute("role","region");d.setAttribute("aria-label",a.langFormat("accessibility.screenReaderRegionLabel",{chart:a}));d.innerHTML=b.screenReaderSectionFormatter?b.screenReaderSectionFormatter(a):this.defaultScreenReaderSectionFormatter(a);
a.getCSV&&a.options.accessibility.addTableShortcut&&(b="highcharts-data-table-"+a.index,h.innerHTML=a.langFormat("accessibility.viewAsDataTable",{chart:a}),h.href="#"+b,h.setAttribute("tabindex","-1"),h.setAttribute("role","button"),h.setAttribute("aria-expanded",!1),h.onclick=a.options.accessibility.onTableAnchorClick||function(){a.viewData()},f.appendChild(h),d.appendChild(f));k.innerHTML=a.langFormat("accessibility.chartHeading",{chart:a});k.setAttribute("aria-hidden",!1);a.renderTo.insertBefore(k,
a.renderTo.firstChild);a.renderTo.insertBefore(d,a.renderTo.firstChild);this.unhideElementFromScreenReaders(d);g(!0,k.style,this.hiddenStyle);g(!0,d.style,this.hiddenStyle)},defaultScreenReaderSectionFormatter:function(){var a=this.chart.options;return this.defaultTypeDescriptionHTML(this.chart)+this.defaultSubtitleHTML(a)+this.defaultCaptionHTML(a)+this.defaultAxisDescriptionHTML("xAxis")+this.defaultAxisDescriptionHTML("yAxis")},defaultCaptionHTML:function(a){var e=a.caption;e=e&&e.text;return(a=
a.accessibility.description||e)?b("div",a):""},defaultAxisDescriptionHTML:function(a){return(a=this.getAxesDescription()[a])?b("div",a):""},defaultTypeDescriptionHTML:function(a){return a.types?b("h5",a.options.accessibility.typeDescription||a.getTypeDescription(a.types)):""},defaultSubtitleHTML:function(a){return(a=(a=a.subtitle)&&a.text)?b("div",a):""},getAxesDescription:function(){var a=this.chart,b=this,d=a.xAxis,f=1<d.length||d[0]&&c(d[0].options.accessibility&&d[0].options.accessibility.enabled,
!a.angular&&a.hasCartesianSeries&&0>a.types.indexOf("map")),g=a.yAxis,h=1<g.length||g[0]&&c(g[0].options.accessibility&&g[0].options.accessibility.enabled,a.hasCartesianSeries&&0>a.types.indexOf("map")),k={};f&&(k.xAxis=a.langFormat("accessibility.axis.xAxisDescription"+(1<d.length?"Plural":"Singular"),{chart:a,names:a.xAxis.map(function(a){return a.getDescription()}),ranges:a.xAxis.map(function(a){return b.getAxisRangeDescription(a)}),numAxes:d.length}));h&&(k.yAxis=a.langFormat("accessibility.axis.yAxisDescription"+
(1<g.length?"Plural":"Singular"),{chart:a,names:a.yAxis.map(function(a){return a.getDescription()}),ranges:a.yAxis.map(function(a){return b.getAxisRangeDescription(a)}),numAxes:g.length}));return k},getAxisRangeDescription:function(a){var b=this.chart,c=a.options||{};if(c.accessibility&&void 0!==c.accessibility.rangeDescription)return c.accessibility.rangeDescription;if(a.categories)return b.langFormat("accessibility.axis.rangeCategories",{chart:b,axis:a,numCategories:a.dataMax-a.dataMin+1});if(a.isDatetimeAxis&&
(0===a.min||0===a.dataMin)){var d={},f="Seconds";d.Seconds=(a.max-a.min)/1E3;d.Minutes=d.Seconds/60;d.Hours=d.Minutes/60;d.Days=d.Hours/24;["Minutes","Hours","Days"].forEach(function(a){2<d[a]&&(f=a)});d.value=d[f].toFixed("Seconds"!==f&&"Minutes"!==f?1:0);return b.langFormat("accessibility.axis.timeRange"+f,{chart:b,axis:a,range:d.value.replace(".0","")})}c=b.options.accessibility;return b.langFormat("accessibility.axis.rangeFromTo",{chart:b,axis:a,rangeFrom:a.isDatetimeAxis?b.time.dateFormat(c.axisRangeDateFormat,
a.min):a.min,rangeTo:a.isDatetimeAxis?b.time.dateFormat(c.axisRangeDateFormat,a.max):a.max})}});return h});m(f,"modules/accessibility/components/ContainerComponent.js",[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/utilities.js"]],function(d,f,h){var g=d.win.document,c=h.stripHTMLTagsFromString;h=function(b){this.initBase(b)};h.prototype=new f;d.extend(h.prototype,{onChartUpdate:function(){var b=this.chart,a=b.options.accessibility,e="highcharts-title-"+
b.index,d=b.options.title.text||b.langFormat("accessibility.defaultChartTitle",{chart:b}),f=c(b.langFormat("accessibility.svgContainerTitle",{chartTitle:d})),h=c(b.langFormat("accessibility.svgContainerLabel",{chartTitle:d}));if(f.length){var m=this.svgTitleElement=this.svgTitleElement||g.createElementNS("http://www.w3.org/2000/svg","title");m.textContent=f;m.id=e;b.renderTo.insertBefore(m,b.renderTo.firstChild)}b.renderer.box&&h.length&&b.renderer.box.setAttribute("aria-label",h);"disabled"!==a.landmarkVerbosity?
b.renderTo.setAttribute("role","region"):b.renderTo.removeAttribute("role");b.renderTo.setAttribute("aria-label",b.langFormat("accessibility.chartContainerLabel",{title:c(d),chart:b}));if(a=b.credits&&b.credits.element)b.credits.textStr&&a.setAttribute("aria-label",c(b.langFormat("accessibility.credits",{creditsStr:b.credits.textStr}))),this.unhideElementFromScreenReaders(a)},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0);this.destroyBase()}});return h});m(f,"modules/accessibility/high-contrast-mode.js",
[f["parts/Globals.js"]],function(d){var f=d.isMS,h=d.win,g=h.document;return{isHighContrastModeActive:function(){if(h.matchMedia&&f&&/Edge\/\d./i.test(h.navigator.userAgent))return h.matchMedia("(-ms-high-contrast: active)").matches;if(f&&h.getComputedStyle){var c=g.createElement("div");c.style.backgroundImage="url(#)";g.body.appendChild(c);var b=(c.currentStyle||h.getComputedStyle(c)).backgroundImage;g.body.removeChild(c);return"none"===b}return!1},setHighContrastTheme:function(c){c.highContrastModeActive=
!0;var b=c.options.accessibility.highContrastTheme;c.update(b,!1);c.series.forEach(function(a){var c=b.plotOptions[a.type]||{};a.update({color:c.color||"windowText",colors:[c.color||"windowText"],borderColor:c.borderColor||"window"});a.points.forEach(function(a){a.options&&a.options.color&&a.update({color:c.color||"windowText",borderColor:c.borderColor||"window"},!1)})});c.redraw()}}});m(f,"modules/accessibility/high-contrast-theme.js",[],function(){return{chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},
subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:null},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",
borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},
errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",
style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},
scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}}});m(f,"modules/accessibility/options.js",[],function(){return{accessibility:{enabled:!0,pointDescriptionThreshold:200,pointNavigationThreshold:!1,addTableShortcut:!0,axisRangeDateFormat:"%Y-%m-%d %H:%M:%S",describeSingleSeries:!1,landmarkVerbosity:"all",keyboardNavigation:{enabled:!0,
skipNullPoints:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:"#335cad",lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","chartMenu","legend"],wrapAround:!0},announceNewData:{enabled:!1,minAnnounceInterval:5E3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}}});m(f,"modules/accessibility/a11y-i18n.js",[f["parts/Globals.js"]],function(d){function f(d,c){var b=d.indexOf("#each("),
a=d.indexOf("#plural("),e=d.indexOf("["),f=d.indexOf("]");if(-1<b){e=d.slice(b).indexOf(")")+b;var g=d.substring(0,b);a=d.substring(e+1);e=d.substring(b+6,e).split(",");b=Number(e[1]);d="";if(c=c[e[0]])for(b=isNaN(b)?c.length:b,b=0>b?c.length+b:Math.min(b,c.length),e=0;e<b;++e)d+=g+c[e]+a;return d.length?d:""}if(-1<a){g=d.slice(a).indexOf(")")+a;d=d.substring(a+8,g).split(",");switch(Number(c[d[0]])){case 0:d=h(d[4],d[1]);break;case 1:d=h(d[2],d[1]);break;case 2:d=h(d[3],d[1]);break;default:d=d[1]}d?
(c=d,c=c.trim&&c.trim()||c.replace(/^\s+|\s+$/g,"")):c="";return c}return-1<e?(a=d.substring(0,e),d=Number(d.substring(e+1,f)),c=c[a],!isNaN(d)&&c&&(0>d?(g=c[c.length+d],void 0===g&&(g=c[0])):(g=c[d],void 0===g&&(g=c[c.length-1]))),void 0!==g?g:""):"{"+d+"}"}var h=d.pick;d.i18nFormat=function(g,c,b){var a=function(a,b){a=a.slice(b||0);var c=a.indexOf("{"),e=a.indexOf("}");if(-1<c&&e>c)return{statement:a.substring(c+1,e),begin:b+c+1,end:b+e}},e=[];var h=0;do{var l=a(g,h);h=g.substring(h,l&&l.begin-
1);h.length&&e.push({value:h,type:"constant"});l&&e.push({value:l.statement,type:"statement"});h=l&&l.end+1}while(l);e.forEach(function(a){"statement"===a.type&&(a.value=f(a.value,c))});return d.format(e.reduce(function(a,b){return a+b.value},""),c,b)};d.Chart.prototype.langFormat=function(f,c,b){f=f.split(".");for(var a=this.options.lang,e=0;e<f.length;++e)a=a&&a[f[e]];return"string"===typeof a&&d.i18nFormat(a,c,b)};d.setOptions({lang:{accessibility:{screenReaderRegionLabel:"Chart screen reader information.",
defaultChartTitle:"Chart",viewAsDataTable:"View as data table.",chartHeading:"Chart graphic.",chartContainerLabel:"{title}. Highcharts interactive chart.",credits:"Chart credits: {creditsStr}",svgContainerLabel:"Interactive chart",rangeSelectorMinInput:"Select start date.",rangeSelectorMaxInput:"Select end date.",tableSummary:"Table representation of chart.",mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom",drillUpButton:"{buttonText}",rangeSelectorButton:"Select range {buttonText}",
legendLabel:"Toggle series visibility",legendItem:"Toggle visibility of {itemName}",thousandsSep:",",svgContainerTitle:"",svgContainerEnd:"End of interactive chart",announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},
seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",
columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",
mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",
lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",
scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",
yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart export",menuButtonLabel:"View export menu",
exportRegionLabel:"Chart export menu"},series:{summary:{"default":"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",
splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",
pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",
boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",
mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",
yAxisDescription:"Y axis, {name}"}}}})});m(f,"modules/accessibility/accessibility.js",[f["parts/Globals.js"],f["modules/accessibility/KeyboardNavigationHandler.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigation.js"],f["modules/accessibility/components/LegendComponent.js"],f["modules/accessibility/components/MenuComponent.js"],f["modules/accessibility/components/SeriesComponent.js"],f["modules/accessibility/components/ZoomComponent.js"],f["modules/accessibility/components/RangeSelectorComponent.js"],
f["modules/accessibility/components/InfoRegionComponent.js"],f["modules/accessibility/components/ContainerComponent.js"],f["modules/accessibility/high-contrast-mode.js"],f["modules/accessibility/high-contrast-theme.js"],f["modules/accessibility/options.js"]],function(d,f,h,g,c,b,a,e,m,l,t,r,k,p){function n(a){this.init(a)}var q=d.addEvent,z=d.win.document,x=d.pick,y=d.merge,A=d.extend,B=d.error;y(!0,d.defaultOptions,p,{accessibility:{highContrastTheme:k}});d.KeyboardNavigationHandler=f;d.AccessibilityComponent=
h;d.extend(d.SVGElement.prototype,{addFocusBorder:function(a,b){this.focusBorder&&this.removeFocusBorder();var c=this.getBBox();a=x(a,3);c.x+=this.translateX?this.translateX:0;c.y+=this.translateY?this.translateY:0;this.focusBorder=this.renderer.rect(c.x-a,c.y-a,c.width+2*a,c.height+2*a,b&&b.borderRadius).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup);this.renderer.styledMode||this.focusBorder.attr({stroke:b&&b.stroke,"stroke-width":b&&b.strokeWidth})},removeFocusBorder:function(){this.focusBorder&&
(this.focusBorder.destroy(),delete this.focusBorder)}});d.Chart.prototype.setFocusToElement=function(a,b){var c=this.options.accessibility.keyboardNavigation.focusBorder;(b=b||a.element)&&b.focus&&(b.hcEvents&&b.hcEvents.focusin||q(b,"focusin",function(){}),b.focus(),c.hideBrowserFocusOutline&&(b.style.outline="none"));c.enabled&&(this.focusElement&&this.focusElement.removeFocusBorder(),a.addFocusBorder(c.margin,{stroke:c.style.color,strokeWidth:c.style.lineWidth,borderRadius:c.style.borderRadius}),
this.focusElement=a)};d.Axis.prototype.getDescription=function(){return this.userOptions&&this.userOptions.accessibility&&this.userOptions.accessibility.description||this.axisTitle&&this.axisTitle.textStr||this.options.id||this.categories&&"categories"||this.isDatetimeAxis&&"Time"||"values"};n.prototype={init:function(d){var f=d.options.accessibility;this.chart=d;if(z.addEventListener&&d.renderer.isSVG){this.copyDeprecatedOptions();var h=this.components={container:new t(d),infoRegion:new l(d),legend:new c(d),
chartMenu:new b(d),rangeSelector:new m(d),series:new a(d),zoom:new e(d)};f.customComponents&&A(this.components,f.customComponents);this.keyboardNavigation=new g(d,h);this.update()}else d.renderTo.setAttribute("aria-hidden",!0)},update:function(){var a=this.components,b=this.chart,c=b.options.accessibility;b.types=this.getChartTypes();Object.keys(a).forEach(function(b){a[b].onChartUpdate()});this.keyboardNavigation.update(c.keyboardNavigation.order);!b.highContrastModeActive&&r.isHighContrastModeActive(b)&&
r.setHighContrastTheme(b)},destroy:function(){var a=this.chart||{},b=this.components;Object.keys(b).forEach(function(a){b[a].destroy()});this.keyboardNavigation&&this.keyboardNavigation.destroy();a.renderTo&&a.renderTo.setAttribute("aria-hidden",!0);a.focusElement&&a.focusElement.removeFocusBorder()},getChartTypes:function(){var a={};this.chart.series.forEach(function(b){a[b.type]=1});return Object.keys(a)},copyDeprecatedOptions:function(){var a=this.chart,b=function(b,c){B("Highcharts: Deprecated option "+
b+" used. Use "+c+" instead.",!1,a)},c={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]},d=a.options.chart||{},e=a.options.accessibility||{};["description","typeDescription"].forEach(function(a){d[a]&&(e[a]=d[a],b("chart."+a,"accessibility."+a))});a.axes.forEach(function(a){(a=a.options)&&a.description&&
(a.accessibility=a.accessibility||{},a.accessibility.description=a.description,b("axis.description","axis.accessibility.description"))});a.series&&a.series.forEach(function(a){Object.keys(c).forEach(function(d){var e=a.options[d];if(void 0!==e){e="skipKeyboardNavigation"===d?!e:e;for(var f=c[d],g=a.options,h,k=0;k<f.length-1;++k)h=f[k],g=g[h]=x(g[h],{});g[f[f.length-1]]=e;b("series."+d,"series."+c[d].join("."))}});a.points&&a.points.forEach(function(a){a.options&&a.options.description&&(a.options.accessibility=
a.options.accessibility||{},a.options.accessibility.description=a.options.description,b("point.description","point.accessibility.description"))})})}};q(d.Chart,"render",function(a){var b=this.accessibility;if(this.a11yDirty&&this.renderTo){delete this.a11yDirty;var c=this.options.accessibility;c&&c.enabled?b?b.update():this.accessibility=b=new n(this):b?(b.destroy&&b.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)}b&&Object.keys(b.components).forEach(function(c){b.components[c].onChartRender(a)})});
q(d.Chart,"update",function(a){if(a=a.options.accessibility)a.customComponents&&(this.options.accessibility.customComponents=a.customComponents,delete a.customComponents),y(!0,this.options.accessibility,a),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility);this.a11yDirty=!0});q(d.Point,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(a){q(d.Chart,a,function(){this.a11yDirty=
!0})});["update","updatedData","remove"].forEach(function(a){q(d.Series,a,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(a){q(d.Chart,a,function(){this.accessibility&&this.accessibility.update()})});q(d.Chart,"destroy",function(){this.accessibility&&this.accessibility.destroy()})});m(f,"masters/modules/accessibility.src.js",[],function(){})});
//# sourceMappingURL=accessibility.js.map